/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.packageconfigurationdialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.packageconfigurationdialog.PackageConfigurationDialogController;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class SaveProjectActionListener
implements ActionListener {
    public static PackageConfigurationDialogController controller;

    public SaveProjectActionListener(PackageConfigurationDialogController controller) {
        SaveProjectActionListener.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (controller.getPackageConfigDialog().getTextDocumentation().getText().equals("")) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Project has no documentation.", "ONooJ", 0);
            return;
        }
        SaveProjectActionListener.saveAsProject();
    }

    public static void saveAsProject() {
        JFileChooser jFileChooser = Launcher.getSaveProjectChooser();
        File currentDir = new File(Launcher.preferences.openProjDir);
        jFileChooser.setCurrentDirectory(currentDir);
        int result = jFileChooser.showSaveDialog(controller.getPackageConfigDialog());
        if (result != 0) {
            return;
        }
        String fullName = jFileChooser.getSelectedFile().getAbsolutePath();
        if (!FilenameUtils.getExtension(fullName).equals("jnop")) {
            fullName = fullName + ".jnop";
        }
        CursorChangeEffect.setCustomCursor(3);
        controller.setFullName(fullName);
        controller.save();
        CursorChangeEffect.setCustomCursor(0);
    }

    public static void saveProject() {
        String txt = controller.getFullName();
        if (txt == null) {
            SaveProjectActionListener.saveAsProject();
        } else {
            CursorChangeEffect.setCustomCursor(3);
            controller.save();
            CursorChangeEffect.setCustomCursor(0);
        }
    }
}

